{gestion complte des solides 3D }
{$S-,R-,N-,G-}
Unit ZSolid;

interface

uses crt,FastKbd,FastMouse,ZGraph;

const
	Z_COLORRGB:array[0..7] of longint=(
		$FFFF00,
          $0000FF,
		$FF0000,
		$00FF00,
          $0000FF,
		$FF0000,
		$00FF00,
          $FFFFFF
	);

	{ couleurs }
	Z_YELLOW	=0;
	Z_BLUE	=1;
	Z_RED	=2;
	Z_GREEN	=3;
	Z_WHITE	=7;

	{ attributs }
	Z_NORMAL	=$0000;		{ facettes avec lumire normale }
	Z_GRID	=$0001;		{ fil de fer }
	Z_GOURAUD =$0002;		{ interpolation linaire de la couleur }
	Z_BACK	=$0010;		{ limination des facettes derrire }
	{ dcimales }
	DECBASE	=$4000;		{ c'est aussi la base des angles }

Type
	TMat33=array[0..2,0..2] of integer;
	TVect3=array[0..2] of integer;
	TSolidProc=function(T:longint):integer;

{ gestion des solides }
function CreateSolid(NPtsMax,NbFacMax,col,stat:integer):integer;
procedure DeleteSolid(h:integer);
procedure DPT(h:integer;n,px,py,pz:integer);
procedure DF(h:integer;pts,a1,a2,a3,a4:integer);
procedure SetSolidPos(h,dh:integer;var m:TMat33;var v:TVect3);
procedure SetSolidP(h,dh:integer;theta,phi,x,y,z:integer);
procedure SetSolidColor(h:integer;c:integer);

{ gestion camra }
procedure SetCameraP(h:integer;alpha,theta,phi,focal,d:integer);

{ gestion source lumineuse }
procedure SetLuminosity(theta,phi,value,fond:integer);

{ lancement de l'animation }
procedure StartAnim(GDriver:integer;pr:TSolidProc);

{ calculs }
procedure MulMat33(var c,a,b:TMat33);
procedure MulMatV3(var c:Tvect3;var a:TMat33;var b:TVect3);
procedure MatID33(var a:TMat33);
function SinI(a:integer):integer;
function CosI(a:integer):integer;
function MulI(a,b:integer):integer;
function DivI(a,b:integer):integer;
procedure RotMat33(var m:TMat33;theta,phi:integer);
procedure Rot1Mat33(var m:Tmat33;theta,a1:integer);

implementation

const
	NBSOLID=50;
	NBFIMAX=4000;
	{ erreurs }
	ER_BADH=1;
	ER_MEMORY=2;
	ER_BADP=3;

	{ prcision du sinus }
	SINTABBIT=10;
	SINTABSIZE=(1 shl SINTABBIT);

Type
	dw=record l,h:word end;
	TPoint=record
		p:TVect3;
		po:TVect3;
		pn:TVect3;
		pc:array[0..1] of integer;
		pco:word;
	end;
	PPoint=^TPoint;
const
	TPointSize=sizeof(Tpoint);
type
	TabPoint=array[0..2500] of TPoint;
	TFace=record
		p:array[0..3] of PPoint;		{ pointeur sur les points }
		norm:array[0..2] of integer;	{ vecteur normal norm }
		zmoy:integer;				{ valeur z moyen: pour le tri }
		n:byte;	{ n and $F: nombre de points, n and $F0: $80:lignes, $40: gouraud }
		co:byte;					{ couleur }
	end;
const
	TFaceSize=sizeof(TFace);
type
	PFace=^TFace;
	TabFace=array[0..2500] of TFace;

	TSolid=record
		nbf,nbfmax,nbpmax:word;
		pf:^TabFace;
		pp:^TabPoint;
		GMat:TMat33;		{ matrice & position globale }
		GPos:TVect3;
		LMat:TMat33;   	{ matrice & position locale }
		LPos:TVect3;
		llumvec:TVect3;	{ vecteur luminosit local: utilis dans le calcul }
		leyepos:Tvect3;	{ pour l'oeil: calcul }
		dad:integer;		{ solide pre servant de rfrence }
		next,son:integer;	{ utiliss pendant les calculs }
		Color:integer;
		free,Status:integer;
		temp:boolean;
	end;
	PSolid=^TSolid;

	TabOrder=array[0..NBFIMAX-1] of PFace;
var
	SO:array[0..NBSOLID-1] of TSolid;
	CSolid:integer;	{ solide sur lequel est fix la camra }
	CMat:TMat33;		{ matrice & position camra }
	CPos:TVect3;
	CFocal:integer;			{ distance focale de la camra }
	CFocalX,CfocalY:integer;		{ multiplication pour X et Y }
	LumVec,LumVec1:TVect3;		{ vecteur norm pour la direction de la lumire }
	LumFond,LumValue:integer;	{ intensit lumire de 0  DECBASE-1 }
	sintable:array[0..SINTABSIZE] of integer;
	PFO,PFO1:^TabOrder;
	nbfi:word;
	xcentre,ycentre:integer;	{ position du centre de l'cran }
	ratiox,ratioy:integer;	{ ratio: pixel/mm*256 }
	nbcolor,coloramp,nbcol3D:integer;
	{ couleurs de base supports par toutes les cartes }
	twhite,tyellow,tblue:integer;


procedure Error(n:integer);
var s:string;
begin
	case n of
	ER_BADH: s:='Bad solid header';
	ER_MEMORY: s:='Not enough memory';
	ER_BADP: s:='Bad Parameter';
	else s:='Unknown';
	end;
	writeln('Fatal Error: ',s);
	halt;
end;

{ Calcul numrique }
procedure WMat(var m:Tmat33);
var i,j:integer;
begin
	for i:=0 to 2 do begin
		for j:=0 to 2 do write(m[i,j]:5);
		writeln;
	end;
end;

procedure InitSinTable;
var i:integer;
begin
	for i:=0 to SINTABSIZE do begin
          sintable[i]:=round(sin(i*(pi/2/SINTABSIZE))*DECBASE);
	end;
end;

function SinI(a:integer):integer; assembler;
asm
	mov bx,a
	and bx,(DECBASE-1)
	cmp bx,(DECBASE/2)
	jae @1
	cmp bx,(DECBASE/4)
	jbe @2
	neg bx
	add bx,(DECBASE/2)
@2:
	mov cl,(12-SINTABBIT)
	shr bx,cl
	shl bx,1
	mov ax,[bx+offset sintable]
	jmp @fin
@1:
	sub bx,(DECBASE/2)
	cmp bx,(DECBASE/4)
	jbe @3
	neg bx
	add bx,(DECBASE/2)
@3:
	mov cl,(12-SINTABBIT)
	shr bx,cl
	shl bx,1
	mov ax,[bx+offset sintable]
	neg ax
@fin:
end;

function CosI(a:integer):integer; assembler;
asm
	mov ax,DECBASE/4
	sub ax,a
	push ax
	call SinI
end;
	

function DivI(a,b:integer):integer; assembler;
asm
	mov dx,a
	xor ax,ax
	sar dx,1
	rcr ax,1
	sar dx,1
	rcr ax,1
	idiv b
end;

function MulI(a,b:integer):integer; assembler;
asm
	mov ax,a
	imul b
	shl ax,1
	rcl dx,1
	shl ax,1
	rcl dx,1
	mov ax,dx
end;

function MulDivI(a,b,c:integer):integer; assembler;
asm
	mov ax,a
	imul b
	idiv c
end;

function mul1(a,b:integer):longint; assembler;
asm
	mov ax,a
	imul b
end;

procedure RotMat33(var m:TMat33;theta,phi:integer);
var ct,cp,st,sp:integer;
begin
	ct:=cosi(theta);
	cp:=cosi(phi);
	st:=sini(theta);
	sp:=sini(phi);
	m[0,0]:=muli(ct,cp);
	m[0,1]:=-muli(st,cp);
	m[0,2]:=sp;
	m[1,0]:=st;
	m[1,1]:=ct;
	m[1,2]:=0;
	m[2,0]:=-muli(sp,ct);
	m[2,1]:=muli(st,sp);
	m[2,2]:=cp;
end;

{ matrice de rotation autour de l'axe a1 }
procedure Rot1Mat33(var m:Tmat33;theta,a1:integer);
var a2,a3,s,c:integer;
begin
	s:=sini(theta);
	c:=cosi(theta);
	a2:=a1+1;
	if a2>2 then a2:=0;
	a3:=a2+1;
	if a3>2 then a3:=0;
	m[a1,a1]:=DECBASE;	m[a1,a2]:=0;	m[a1,a3]:=0;
	m[a2,a1]:=0;	m[a2,a2]:=c;	m[a2,a3]:=-s;
	m[a3,a1]:=0;	m[a3,a2]:=s;	m[a3,a3]:=c;
end;

function renorm1(a:longint):integer; assembler;
asm
	mov dx,word ptr [a]
	mov ax,word ptr [a+2]
	shl dx,1
	rcl ax,1
	shl dx,1
	rcl ax,1
end;

procedure MatID33(var a:TMat33);
begin
	a[0,0]:=DECBASE; a[0,1]:=0; a[0,2]:=0;
	a[1,0]:=0; a[1,1]:=DECBASE; a[1,2]:=0;
	a[2,0]:=0; a[2,1]:=0; a[2,2]:=DECBASE;
end;


procedure MulMat33(var c,a,b:TMat33);
var m:TMat33;
begin
asm
	push ds
	cld
     lds bx,a
	les di,b
	xor si,si
@1:
	push si
	mov ax,[bx]
	imul es:word[di]
	mov si,ax ; mov cx,dx
	mov ax,[bx+2]
	imul es:word[di+6]
	add si,ax ; adc cx,dx
	mov ax,[bx+4]
	imul es:word[di+12]
	add si,ax ; adc cx,dx
	shl si,1 ; rcl cx,1 ; shl si,1 ; rcl cx,1
	pop si
	mov word[m+si],cx
     add di,2

	add si,2
	cmp si,6
     jne @2
@3:
	sub di,6
	add bx,6
	jmp @1
@2:
	cmp si,12
	je @3
	cmp si,18
	jne @1

	mov ax,ss
	mov ds,ax
     lea si,m
	les di,c
	mov cx,9
	rep movsw

	pop ds
end;
end;

procedure MulMatV3(var c:Tvect3;var a:TMat33;var b:TVect3);
begin
	c[0]:=renorm1(mul1(a[0,0],b[0])+mul1(a[0,1],b[1])+mul1(a[0,2],b[2]));
	c[1]:=renorm1(mul1(a[1,0],b[0])+mul1(a[1,1],b[1])+mul1(a[1,2],b[2]));
	c[2]:=renorm1(mul1(a[2,0],b[0])+mul1(a[2,1],b[1])+mul1(a[2,2],b[2]));
end;

procedure AddV3(var c,a,b:TVect3);
begin
	c[0]:=a[0]+b[0];
	c[1]:=a[1]+b[1];
	c[2]:=a[2]+b[2];
end;

procedure SubV3(var c,a,b:TVect3);
begin
	c[0]:=a[0]-b[0];
	c[1]:=a[1]-b[1];
	c[2]:=a[2]-b[2];
end;

procedure TrnMat33(var b,a:TMat33);
var i,j:integer;
begin
	for i:=0 to 2 do
	for j:=0 to 2 do b[i,j]:=a[j,i];
end;

procedure ProdV3(var c,a,b:Tvect3);
begin
	c[0]:=a[1]*b[2]-a[2]*b[1];
	c[1]:=a[2]*b[0]-a[0]*b[2];
	c[2]:=a[0]*b[1]-a[1]*b[0];
end;

function DotV3(var a,b:Tvect3):longint;
begin
	DotV3:=mul1(a[0],b[0])+mul1(a[1],b[1])+mul1(a[2],b[2]);
end;

function EqV3(var v1,v2:TVect3):boolean;
begin
	EqV3:=(v1[0]=v2[0]) and (v1[1]=v2[1]) and (v1[2]=v2[2]);
end;

{ *********************************************************************** }

procedure SetSolidColor(h:integer;c:integer);
begin
	if (h<1) or (h>=NBSOLID) or (so[h].free<>0) then Error(ER_BADH);
	so[h].color:=(c mod nbcol3D)*coloramp+1;
end;

function CreateSolid(NPtsMax,NbFacMax,col,stat:integer):integer;
var a:integer;
begin
	a:=1;
	while (a<NBSOLID) and (so[a].free=0) do inc(a);
	if (a=NBSOLID) then Error(ER_MEMORY);

	with SO[a] do begin
		free:=0;
		nbpmax:=nptsmax;
		nbfmax:=nbfacmax;
		nbf:=0;
		status:=stat;
		getmem(pp,nbpmax*sizeof(TPoint));
		getmem(pf,nbfmax*sizeof(TFace));
		MatID33(Gmat);
		gpos[0]:=0;
		gpos[1]:=0;
		gpos[2]:=0;
		MatID33(LMat);
		lpos[0]:=0;
		lpos[1]:=0;
		lpos[2]:=0;
		dad:=0;
		temp:=false;
	end;
	SetSolidcolor(a,col);
	CreateSolid:=a;
end;
	
procedure DeleteSolid(h:integer);
begin
	if (h<1) or (h>=NBSOLID) or (so[h].free<>0) then Error(ER_BADH);
	with SO[h] do begin
		freemem(pp,nbpmax*sizeof(TPoint));
		freemem(pf,nbfmax*sizeof(TFace));
		free:=1;
	end;
end;

procedure DPT(h:integer;n,px,py,pz:integer);
var	p:^TPoint;
begin
	if (h<1) or (h>=NBSOLID) or (so[h].free<>0) then Error(ER_BADH);
	if (n>=so[h].nbpmax) then Error(ER_MEMORY);
	p:=@so[h].pp^[n];
	p^.p[0]:=px;
	p^.p[1]:=py;
	p^.p[2]:=pz;
	p^.pn[0]:=0;
	p^.pn[1]:=0;
	p^.pn[2]:=DECBASE;
end;



procedure DF(h:integer;pts,a1,a2,a3,a4:integer);
var	p:PFace;
	i,j:integer;
	v1,v2,v3:Tvect3;
	r,x,y,z:real;

begin
	if (h<1) or (h>=NBSOLID) or (so[h].free<>0) then Error(ER_BADH);
	with so[h] do begin
		if nbf>=nbfmax then Error(ER_MEMORY);
		with pf^[nbf] do begin
			p[0]:=@pp^[a1];
			p[1]:=@pp^[a2];
			p[2]:=@pp^[a3];
			p[3]:=@pp^[a4];
			n:=pts;
			{ limination des points redondants }
			i:=0;
			while (i<(n-1)) do begin
				j:=i+1;
				while (j<n) and (not EqV3(p[i]^.p,p[j]^.p)) do inc(j);
				if j<n then begin
					for j:=i to n-2 do p[j]:=p[j+1];
					dec(n);
				end;
				inc(i);
			end;
			if n<=1 then exit;
			{ calcul du vecteur norme }
			if (n>=3) then begin
				v1:=p[1]^.p;
				v2:=p[0]^.p;
				v3:=p[2]^.p;
				SubV3(v2,v2,v1);
				SubV3(v3,v3,v1);
				x:=mul1(v2[1],v3[2])-mul1(v2[2],v3[1]);
				y:=mul1(v2[2],v3[0])-mul1(v2[0],v3[2]);
				z:=mul1(v2[0],v3[1])-mul1(v2[1],v3[0]);
          		r:=sqrt(sqr(x)+sqr(y)+sqr(z));
				norm[0]:=trunc(x/r*DECBASE);
				norm[1]:=trunc(y/r*DECBASE);
				norm[2]:=trunc(z/r*DECBASE);
			end;
		end;
		inc(nbf);
	end;
end;

{ calcul des normales en chaque point }
procedure CalcNormPT(ps:PSolid);
type dw=record l,h:word end;
var	n,np,nf,i,j,k:integer;
	pp:^TabPoint;
	pf:PFace;
	v:array[0..2] of real;
	r:real;
	pt:PPoint;
begin
	pp:=pointer(ps^.pp);
	pf:=PFace(ps^.pf);
     np:=ps^.nbpmax;
	nf:=ps^.nbf;
	for i:=0 to np-1 do begin
          v[0]:=0;
		v[1]:=0;
		v[2]:=0;
		pf:=PFace(ps^.pf);
		pt:=@pp^[i];
		for j:=0 to nf-1 do begin
			n:=pf^.n and $0F;
			for k:=0 to n-1 do if pf^.p[k]=pt then begin
                	v[0]:=v[0]+pf^.norm[0];
                	v[1]:=v[1]+pf^.norm[1];
                	v[2]:=v[2]+pf^.norm[2];
			end;
			inc(dw(pf).l,sizeof(TFace));
		end;
		r:=sqrt(sqr(v[0])+sqr(v[1])+sqr(v[2]));
          if r<>0 then begin
          	pt^.pn[0]:=trunc(v[0]/r*DECBASE);
          	pt^.pn[1]:=trunc(v[1]/r*DECBASE);
          	pt^.pn[2]:=trunc(v[2]/r*DECBASE);
		end;
	end;
end;
procedure SetSolidPos(h,dh:integer;var m:TMat33;var v:TVect3);
begin
	if (h<1) or (h>=NBSOLID) or (so[h].free<>0) then exit;
	with so[h] do begin
		dad:=dh;
		lpos:=v;
		lmat:=m;
	end;
end;

procedure SetSolidP(h,dh:integer;theta,phi,x,y,z:integer);
var	m:TMat33;
	g:TVect3;
begin
	RotMat33(m,theta,phi);
	g[0]:=x;
	g[1]:=y;
	g[2]:=z;
	SetSolidPos(h,dh,m,g);
end;
	
{  la fin de la transformation, l'oeil est en [ 0 0 0 ] }
procedure SetCameraP(h:integer;alpha,theta,phi,focal,d:integer);
var	m1,m2,m3:Tmat33;
	g,g2:Tvect3;
begin
	if (h<0) or (h>=NBSOLID) or (so[h].free<>0) then exit;
	CFocal:=focal;
	cfocalx:=MulDivI(focal,ratiox,256);
	cfocaly:=MulDivI(focal,ratioy,256);
	CSolid:=h;
	Rot1Mat33(m1,alpha,2);
	Rot1Mat33(m2,theta,0);
	MulMat33(m3,m1,m2);
	Rot1Mat33(m1,phi,1);
	MulMat33(m2,m3,m1);
     cmat:=m2;
	cpos[0]:=0;
	cpos[1]:=0;
	cpos[2]:=-d;
end;



{ gestion source lumineuse }
procedure SetLuminosity(theta,phi,value,fond:integer);
begin
	LumVec[0]:=muli(cosi(theta),cosi(phi));
	LumVec[1]:=muli(sini(theta),cosi(phi));
	LumVec[2]:=sini(phi);
	LumValue:=value;
	LumFond:=Fond;
end;

{ *********************************************************************** }

{ mise  jour des pointeurs son et next }
procedure UpdateSon;
var a,i:integer;
begin
	for i:=0 to NBSOLID-1 do begin
		so[i].next:=-1;
		so[i].son:=-1;
	end;
	for i:=1 to NBSOLID-1 do if so[i].free=0 then begin
		a:=so[i].dad;
		if so[a].free<>0 then Error(ER_BADH);
		so[i].next:=so[a].son;
		so[a].son:=i;
	end;
end;

{ matrice de la camra }
procedure CalcCamera;
var	a:integer;
	m1,m2:Tmat33;
	g1:TVect3;
begin
	so[0].gpos:=cpos;
	so[0].gmat:=cmat;
	a:=csolid;
	while a<>0 do with so[a] do begin
		if free<>0 then Error(ER_BADH);
		TrnMat33(m2,lmat);
		MulMat33(m1,so[0].gmat,m2);
		so[0].gmat:=m1;
		MulMatV3(g1,so[0].gmat,lpos);
		SubV3(so[0].gpos,so[0].gpos,g1);
		a:=dad;
	end;
	MulMatV3(lumvec1,so[0].gmat,lumvec);
end;

{ on calcule la position des fils de n }
var
	wm1:TMat33;

procedure CalcMatr1(n:integer);
var	a:integer;
	ps:PSolid;

begin
	a:=so[n].son;
	while a>=0 do with so[a] do begin
		{ matrice globale }
		ps:=@so[a];
		MulMat33(gmat,so[n].gmat,ps^.lmat);
		MulMatV3(gpos,so[n].gmat,ps^.lpos);
		AddV3(gpos,gpos,so[n].gpos);
		TrnMat33(wm1,gmat);
		MulMatV3(llumvec,wm1,lumvec1);
		MulMatV3(leyepos,wm1,gpos);
		leyepos[0]:=-leyepos[0];
		leyepos[1]:=-leyepos[1];
		leyepos[2]:=-leyepos[2];
		CalcMatr1(a);

		{ calcul Gouraud }
		if (not ps^.temp) and ((ps^.status and Z_GOURAUD)<>0) then begin
			CalcNormPT(ps);
			ps^.temp:=true;
		end;
		a:=next;
	end;
end;

procedure CalcMatr;
begin
     CalcMatr1(0);
end;

{ *********************************************************************** }
{ Procdure la plus importante: Calcul des facettes aprs rotation        }
{ *********************************************************************** }

{ rotation des points }
Procedure CalcPP(ps:PSolid); assembler;
asm
	push bp
	cld
	mov si,word ptr [ps]
	mov cx,word[si+TSolid.nbpmax]
	or cx,cx
	je @fin
	les di,[si+TSolid.pp]
@1:
	push cx
		{ multiplication de la matrice }
		add si,TSolid.gmat

		mov bp,es:word ptr [di+TPoint.p]

		lodsw ; imul bp
		mov bx,ax ; mov cx,dx
		lodsw ; imul es:word ptr [di+TPoint.p+2]
		add bx,ax ; adc cx,dx
		lodsw ; imul es:word ptr [di+TPoint.p+4]
		add bx,ax ; adc cx,dx
		shl bx,1 ; rcl cx,1 ; shl bx,1 ; rcl cx,1
		add cx,word ptr [si+TSolid.gpos-TSolid.gmat-3*2]
		mov es:word ptr [di+TPoint.po],cx

		lodsw ; imul bp
		mov bx,ax ; mov cx,dx
		lodsw ; imul es:word ptr [di+TPoint.p+2]
		add bx,ax ; adc cx,dx
		lodsw ; imul es:word ptr [di+TPoint.p+4]
		add bx,ax ; adc cx,dx
		shl bx,1 ; rcl cx,1 ; shl bx,1 ; rcl cx,1
		add cx,word ptr [si+TSolid.gpos+2-TSolid.gmat-6*2]
		mov es:word ptr [di+TPoint.po+2],cx

		lodsw ; imul bp
		mov bx,ax ; mov cx,dx
		lodsw ; imul es:word ptr [di+TPoint.p+2]
		add bx,ax ; adc cx,dx
		lodsw ; imul es:word ptr [di+TPoint.p+4]
		add bx,ax ; adc cx,dx
		shl bx,1 ; rcl cx,1 ; shl bx,1 ; rcl cx,1
		add cx,word ptr [si+TSolid.gpos+4-TSolid.gmat-9*2]
		mov es:word ptr [di+TPoint.po+4],cx

		sub si,TSolid.gmat+9*2

		{ projection conique & test de sortie du champ de vision }
		mov dx,cfocal
		sar dx,1
		sar dx,1
		neg dx
		cmp cx,dx
		jl @10
		mov es:word[di+TPoint.pc],8000h
		jmp @20
@10:
		mov ax,cfocalx
          imul es:word[di+TPoint.po]
          idiv cx
		add ax,xcentre
		mov es:word[di+TPoint.pc],ax

		mov ax,cfocaly
		imul es:word[di+TPoint.po+2]
		idiv cx
		mov dx,ycentre
		sub dx,ax
		mov es:word[di+TPoint.pc+2],dx
@20:
	pop cx
	add di,TPointSize
	dec cx
	jne @1
@fin:
	pop bp
end;

{ calcul de la couleur de chaque point pour Gouraud }
Procedure CalcPPN(ps:PSolid); assembler;
asm
	cld
	mov si,word ptr [ps]
	mov cx,word[si+TSolid.nbpmax]
	or cx,cx
	je @fin
	les di,[si+TSolid.pp]
@1:
	push cx

		{ produit scalaire de TPoint.pn par TSolid.llumvec }

		mov ax,es:word[di+TPoint.pn]
		imul word[si+TSolid.llumvec]
		mov bx,ax ; mov cx,dx
		mov ax,es:word[di+TPoint.pn+2]
		imul word[si+TSolid.llumvec+2]
		add bx,ax ; adc cx,dx
		mov ax,es:word[di+TPoint.pn+4]
		imul word[si+TSolid.llumvec+4]
		add bx,ax ; adc cx,dx
		shl bx,1 ; rcl cx,1 ; shl bx,1 ; rcl cx,1

		{ calcul de la couleur }

		or cx,cx
		jns @30
		xor cx,cx
@30:
		mov ax,LumValue
		mul cx
		shl ax,1 ; rcl dx,1 ; shl ax,1 ; rcl dx,1
          add dx,LumFond
		mov ax,ColorAmp
		dec ax
		mul dx
		shl ax,1 ; rcl dx,1 ; shl ax,1 ; rcl dx,1
          cmp dx,0
		je @35
		add dx,[si+TSolid.color]
@35:
		mov es:[di+TPoint.pco],dx

	pop cx
	add di,TPointSize
	dec cx
	jne @1
@fin:
end;

var	pfv1:TVect3;

Procedure CalcPF(ps:PSolid); assembler;
asm
	push bp
	cld
	mov si,word[ps]

     mov cx,[si+TSolid.nbf]
	or cx,cx
	je @fin
	les di,[si+TSolid.pf]
@1:
	push cx

{ calcul couleur }
     mov al,es:[di+TFace.n]
	and al,0Fh
	mov es:[di+TFace.n],al
	cmp al,3
	jae @10
     { cas o on dessine une ligne }
@7:
	mov ax,[si+TSolid.color]
	add ax,coloramp
	dec ax
	mov es:[di+TFace.co],al
	jmp @transfert
@10:
	test [si+TSolid.status],Z_GRID
	je @15
	{ cas o on dessine que les contours des facettes }
	or es:[di+TFace.n],80h
	jmp @7
@15:
	{ si Z_BACK est activ, on regarde si la facette est bien tourne }
	test [si+TSolid.status],Z_BACK
	je @noback
			{ produit scalaire vecteur normal local avec le vecteur leyepos-p[0]^.p }
			push es
			push di
			les di,es:dword[di+TFace.p]
			mov ax,word[si+TSolid.leyepos]
			sub ax,es:word[di+TPoint.p]
			mov word[pfv1],ax
			mov ax,word[si+TSolid.leyepos+2]
			sub ax,es:word[di+TPoint.p+2]
			mov word[pfv1+2],ax
			mov ax,word[si+TSolid.leyepos+4]
			sub ax,es:word[di+TPoint.p+4]
			mov word[pfv1+4],ax
			pop di
			pop es

			mov ax,word[pfv1]
			imul es:word[di+TFace.norm]
			mov bx,ax ; mov cx,dx
			mov ax,word[pfv1+2]
			imul es:word[di+TFace.norm+2]
			add bx,ax ; adc cx,dx
			mov ax,word[pfv1+4]
			imul es:word[di+TFace.norm+4]
			add bx,ax ; adc cx,dx
			shl bx,1 ; rcl cx,1; shl bx,1 ; rcl cx,1
               or cx,cx
			jl @noinsert
@noback:
	{ si Z_GOURAUD n'est pas mis, on calcul la couleur avec TFace.norm }

    	test [si+TSolid.status],Z_GOURAUD
	jne @gouraud

		mov ax,es:word[di+TFace.norm]
		imul word[si+TSolid.llumvec]
		mov bx,ax ; mov cx,dx
		mov ax,es:word[di+TFace.norm+2]
		imul word[si+TSolid.llumvec+2]
		add bx,ax ; adc cx,dx
		mov ax,es:word[di+TFace.norm+4]
		imul word[si+TSolid.llumvec+4]
		add bx,ax ; adc cx,dx
		shl bx,1 ; rcl cx,1 ; shl bx,1 ; rcl cx,1
		or cx,cx
		jns @30
		xor cx,cx
@30:
		mov ax,LumValue
		mul cx
		shl ax,1 ; rcl dx,1 ; shl ax,1 ; rcl dx,1
          add dx,LumFond
		mov ax,ColorAmp
		dec ax
		mul dx
		shl ax,1 ; rcl dx,1 ; shl ax,1 ; rcl dx,1
          cmp dx,0
		je @35
		add dx,[si+TSolid.color]
@35:
		mov es:[di+TFace.co],dl
		jmp @transfert

@gouraud:
	or es:[di+TFace.n],40h

@transfert:
	{ calcul de zmoy & test de sortie grossire selon z }
	mov cl,es:[di+TFace.n]
	and cl,0Fh
	mov ch,0
	mov dx,-32768
	mov ax,32767
	xor bp,bp
	push ds
	push si
@50:
	lds si,es:dword[bp+di+TFace.p]
	mov bx,word[si+TPoint.pc]
	cmp bx,8000h
	jne @54
	pop si
	pop ds
	jmp @noinsert
@54:
	mov bx,word[si+TPoint.po+4]
	cmp bx,dx
	jl @53
	mov dx,bx
@53:
	cmp bx,ax
	jg @60
	mov ax,bx
@60:
	add bp,4
	loop @50
	pop si
	pop ds

	add ax,dx
	rcr ax,1
	mov es:[di+TFace.zmoy],ax

	{ on insre la facette }
	mov ax,ds
	lds bx,PFO1
     mov [bx],di
	mov [bx+2],es
	mov ds,ax
	add word[PFO1],4
@noinsert:

	pop cx
	add di,TFaceSize
	dec cx
	jne @1
@fin:
	pop bp
end;


procedure CalcFaceI1(n:integer);
var	a:integer;
	ps:PSolid;
begin
	a:=so[n].son;
	while a>=0 do begin
          ps:=@so[a];
		CalcPP(ps);
		if (ps^.status and Z_GOURAUD)<>0 then CalcPPN(ps);
		CalcPF(ps);
		CalcFaceI1(a);
		a:=ps^.next;
	end;
end;

procedure CalcFaceI;
begin
	PFO1:=PFO;
     CalcFaceI1(0);
	nbfi:=(dw(PFO1).l-dw(PFO).l) shr 2;
end;

{ QuickSort en assembleur sur le tableau de Pointeurs PFO }
{ ax=l, dx=r, ds:bx= ptr sur PFO }

procedure sort1; assembler;
asm
	mov si,dx
	add si,ax
	rcr si,1
	and si,0FFFCh
	les bp,[si+bx]
	mov cx,es:[bp+TFace.zmoy]
	mov si,ax
	mov di,dx
@loop_1:

@loop_2:
	les bp,[si+bx]
     cmp cx,es:[bp+TFace.zmoy]
	jle @loop_3
	add si,4
	jmp @loop_2
@loop_3:
	les bp,[di+bx]
     cmp cx,es:[bp+TFace.zmoy]
	jge @loop_4
     sub di,4
	jmp @loop_3
@loop_4:
	cmp di,-4
	je @loop_end1
     cmp si,di
     ja @loop_end
	mov bp,[bx+si]
	xchg bp,[bx+di]
	mov [bx+si],bp
	mov bp,[bx+si+2]
	xchg bp,[bx+di+2]
	mov [bx+si+2],bp
     add si,4
	sub di,4
	cmp di,-4
	je @loop_end1
	cmp si,di
	jbe @loop_1
@loop_end:
	cmp ax,di
     jae @loop_end1
	push si
	push dx
	mov dx,di
	call Sort1
	pop dx
	pop si
@loop_end1:
     cmp si,dx
     jae @loop_end2
	mov ax,si
	call Sort1
@loop_end2:
end;

procedure SortFaceI; assembler;
asm
	mov dx,nbfi
	cmp dx,1
	jbe @fin

	push ds
	push bp
	lds bx,PFO
	xor ax,ax
     dec dx
	shl dx,1
	shl dx,1
	call Sort1
	pop bp
	pop ds
@fin:
end;



procedure DrawFaceI;
var 	m,i,j,k:integer;
	P:PFace;
	pts:array[0..3,0..1] of integer;
	ptsc:array[0..3,0..2] of integer;
begin
	for i:=0 to nbfi-1 do begin
		P:=PFO^[i];
		m:=p^.n and $0F;
		case m of
		2: begin
	asm
		les di,P
		mov dx,es
		les si,es:dword[di+TFace.p]
		push es:word[si+TPoint.pc]
		push es:word[si+TPoint.pc+2]
		mov es,dx
		les si,es:dword[di+TFace.p+4]
		push es:word[si+TPoint.pc]
		push es:word[si+TPoint.pc+2]
		mov es,dx
		mov al,es:[di+TFace.co]
		mov ah,0
		push ax
          call ZLine
	end;
		end;
		3,4: begin
			case (p^.n and $F0) of
			{ facettes }
			$00: begin
asm
	mov cx,m
	push cx
	lea bx,pts
	push ss
	push bx
	les di,P
	mov al,es:[di+TFace.co]
     mov ah,0
	push ax
     mov dx,es
@1:
	les si,es:dword[di+TFace.p]
	mov ax,es:word[si+TPoint.pc]
	mov ss:[bx],ax
	mov ax,es:word[si+TPoint.pc+2]
	mov ss:[bx+2],ax
	add bx,4
	add di,4
	mov es,dx
	loop @1

	call ZFillPoly
end;
			end;
			{ fil de fer }
			$80: begin
				for k:=0 to m-1 do for j:=0 to 1 do pts[k,j]:=p^.p[k]^.pc[j];
				k:=0;
				j:=1;
				repeat
				ZLine(pts[k][0],pts[k][1],pts[j][0],pts[j][1],p^.co);
				inc(k);
				inc(j);
				if j=m then j:=0;
				until j=1;
			end;
			{ Gouraud }
			$40: begin
				for k:=0 to m-1 do begin
					for j:=0 to 1 do ptsc[k,j]:=p^.p[k]^.pc[j];
                         ptsc[k,2]:=p^.p[k]^.pco;
				end;
				ZFillPolyC(m,ptsc);
			end;
			end;
		end;
		end;
	end;
end;


function FTimer:longint; assembler;
asm
	cli
	xor ax,ax
	mov es,ax
	mov ax,es:word[46Ch]
	mov dx,es:word[46Eh]
	sti
end;


var tim:longint;

{ Procdure de Base: calcul & affichage de la nouvelle image }
procedure NewImage;
var x1,y1,xs,ys:integer;
begin
{	Port[$43]:=$36;
	Port[$40]:=$00;
	Port[$40]:=$01; }
	ZGetViewPort(x1,y1,xs,ys);
	xcentre:=xs shr 1;
	ycentre:=ys shr 1;
     UpdateSon;
	CalcCamera;
	CalcMatr;
	CalcFaceI;
	SortFaceI;
{	tim:=FTimer; }
	DrawFaceI;
{	tim:=round( (FTimer-tim)*256/1192180*1000 ); }
	tim:=0;

{	Port[$43]:=$36;
	Port[$40]:=$00;
	Port[$40]:=$00; }
end;



procedure MakePal;
type TPal=array[0..3] of byte;
var	p,i,j,k:integer;
	pal:array[0..255,0..2] of byte;
	a:TPal;
begin
	if nbcolor<256 then begin
		pal[15,0]:=63;
		pal[15,1]:=63;
		pal[15,2]:=63;
		coloramp:=7;
		nbcol3D:=2;
		twhite:=15;
	end
	else begin
		pal[255,0]:=63;
		pal[255,1]:=63;
		pal[255,2]:=63;
		coloramp:=31;
		nbcol3D:=8;
		twhite:=255;
	end;
	tyellow:=(Z_YELLOW+1)*coloramp;
	tblue:=(Z_BLUE+1)*coloramp;

	pal[0,0]:=0;
	pal[0,1]:=0;
	pal[0,2]:=0;
	p:=1;
	for k:=0 to nbcol3D-1 do begin
		a:=Tpal(Z_COLORRGB[k]);
     	for i:=0 to coloramp-1 do begin
           	for j:=0 to 2 do begin
				pal[p,j]:=round(a[2-j]/255*(i+1)/coloramp*63);
			end;
			inc(p);
		end;
     end;
	ZinitPal(pal,0,NBColor);
end;


const
	MOUSESPEED=20;

{  Gestion de la prsentation  l'cran & de l'animation }
var
	oldestate,fstate,estate:integer;
	xscr,yscr:integer;
	xtext,ytext:integer;
	{ camra }
	camsolid,camfocal,camx,camy,camz,camalpha,camtheta,camphi,camr,camstate:integer;
	camcmd:word;
	{ lumire }
	lumphi,lumtheta:integer;

	{ autre }
	repstate,imfreq,distinc,angleinc:integer;
	{ souris }
	OldMouseX,OldMouseY:integer;
	NoMouse:integer;

	k:word;
	ti,time:longint;


function fstr(a:longint;n:byte):string;
var s:string;
begin
	str(a:n,s);
	fstr:=s;
end;


function max(a,b:integer):integer;
begin
	if a>b then max:=a else max:=b;
end;

function min(a,b:integer):integer;
begin
	if a<b then min:=a else min:=b;
end;

function rstr(r:real;n,a:byte):string;
var s:string;
begin
	str(r:n:a,s);
	rstr:=s;
end;

function cvtangle(a:integer):integer;
begin
	cvtangle:=round((a and (DECBASE-1))/DECBASE*360);
end;

{ affichage de l'cran }
procedure DrawPage;
var	s:string;
	x,y:integer;
begin
	case estate of
	{ Pas d'informations }
	0: begin
		ZSetViewPort(0,0,xscr,yscr);
          NewImage;
{		s:=fstr(tim,5)+' ms';
		ZOutText(0,24,twhite,0,s); }
	end;
	{ Affichage de tous les paramtres }
	1: begin
		ZSetViewPort(0,0,xscr,yscr);

		s:='Camra:';
		ZOutText(0,0,tyellow,0,s);
		s:='='+fstr(cvtangle(camalpha),3)+' R='+fstr(camr,6);
		ZOutText(0,1,twhite,0,s);
		s:='='+fstr(cvtangle(camtheta),3)+' ='+fstr(cvtangle(camphi),3);
		ZOutText(0,2,twhite,0,s);
		s:='fo='+fstr(camfocal,5);
		ZOutText(0,3,twhite,0,s);
		s:='S='+fstr(camsolid,3);
		ZOutText(0,4,twhite,0,s);

		s:='Lumire: ';
          ZOutText(0,6,tblue,0,s);
		s:='='+fstr(cvtangle(lumtheta),3)+' ='+fstr(cvtangle(lumphi),3);
		ZOutText(0,7,twhite,0,s);



		s:=fstr(nbfi,4)+' faces';
		ZOutText(0,19,twhite,0,s);

          s:='='+rstr(angleinc/DECBASE*360,5,1);
		ZOutText(0,20,twhite,0,s);
		s:='x='+fstr(distinc,5);
		ZOutText(0,21,twhite,0,s);
		s:='T='+fstr(time,7);
		ZOutText(0,22,twhite,0,s);
		s:=fstr(imfreq,3)+' i/s';
		ZOutText(0,23,twhite,0,s);

		s:='F1-AIDE';
		ZOutText(0,24,tblue,0,s);

		x:=15*xtext;
		ZLine(x,0,x,yscr-1,twhite);
		ZSetViewPort(x+1,0,xscr-x-1,yscr);
		NewImage;
	end;
	{ Aide sur les Touches }
     2: begin
		ZSetViewPort(0,0,xscr,yscr);
		s:='Camra:';
		ZOutText(0,0,tblue,0,s);
          s:='Up,Down:   Left,Right:   Home,End: ';
		ZOutText(0,1,twhite,0,s);
		s:='PgUp,PgDn: R';
		ZOutText(0,2,twhite,0,s);
		s:='(la souris change ,,et R)';
		ZOutText(0,3,twhite,0,s);
		s:='Q,W: Solide de base';
		ZOutText(0,4,twhite,0,s);


		s:='Lumire:';
		ZOutText(0,5,tyellow,0,s);
		s:='E,X:   S,D: ';
		ZOutText(0,6,twhite,0,s);

		s:='Divers:';
		ZOutText(0,7,tyellow,0,s);
		s:='F2: Passage en mode plein cran';
		ZOutText(0,8,twhite,0,s);

		s:='(aide provisoire!!)';
		ZOutText(0,9,tyellow,0,s);

		y:=ytext*11;
		ZLine(0,y,XScr-1,y,twhite);
          ZSetViewPort(0,y+1,xscr,yscr-y-1);
		NewImage;


	end;
	end;
	ZView;

end;
const
	D=64;

procedure TestKey;
var mx,my:integer;
begin

if keypressed then begin
	k:=getkey;
	case k of

	{ les 3 angles de la camra }
	LEFTARROW,
	RIGHTARROW,
	UPARROW,
	DOWNARROW,
	HOMEKEY,
	ENDKEY:		camcmd:=k;

	{ distance camra }
	PGUPKEY:		camr:=max(camr-distinc,0);
	PGDNKEY:		camr:=min(camr+distinc,16000);

	{ incrmentations }
	ord('/'): begin
          angleinc:=max(angleinc div 2,DECBASE div 3600);
	end;
	ord('*'): begin
		angleinc:=min(angleinc*2,(DECBASE div 4));
	end;
	ord('-'): begin
		distinc:=max(distinc div 2,1);
	end;
	ord('+'): begin
		distinc:=min(distinc*2,500);
	end;
	ord(' '): begin
		repstate:=1-repstate;
	end;


	{ aide }
	F1KEY: begin
		if estate=2 then estate:=oldestate
		else begin
			oldestate:=estate;
			estate:=2;
		end;
	end;
	{ commutation informations ou pas }
	F2KEY: begin
		if estate=2 then estate:=oldestate
		else begin
			if estate=0 then estate:=1 else estate:=0;
		end;
	end;

	{ solide suivant/prcdent }
	ord('q'),ord('Q'): begin
		repeat
			dec(camsolid);
			if camsolid<0 then camsolid:=NBSOLID-1;
		until so[camsolid].free=0;
	end;
	ord('w'),ord('W'): begin
		repeat
			inc(camsolid);
			if camsolid>=NBSOLID then camsolid:=0;
		until so[camsolid].free=0;
	end;

	{ rotation source de lumire }
	ord('e'),ord('E'): 	lumtheta:=(lumtheta+angleinc) and (DECBASE-1);
	ord('x'),ord('X'):	lumtheta:=(lumtheta-angleinc) and (DECBASE-1);
	ord('s'),ord('S'): 	lumphi:=(lumphi-angleinc) and (DECBASE-1);
	ord('d'),ord('D'): 	lumphi:=(lumphi+angleinc) and (DECBASE-1);

	{ fin du programme }
	ESCKEY: fstate:=1;
	end;
end;

     if NoMouse=0 then begin
		mx:=(MouseX-OldMouseX)*MOUSESPEED;
		my:=(MouseY-OldMouseY)*MOUSESPEED;
		OldMouseX:=MouseX;
		OldMouseY:=MouseY;
		camphi:=(camphi+my) and (DECBASE-1);
		camtheta:=(camtheta-mx) and (DECBASE-1);
		if (MouseBut and $0001)<>0 then begin
			camr:=max(camr-distinc,0);
		end;
		if (MouseBut and $0002)<>0 then begin
			camr:=min(camr+distinc,16000);
		end;
	end;

	case camcmd of
	LEFTARROW:	camphi:=(camphi-angleinc) and (DECBASE-1);
	RIGHTARROW:	camphi:=(camphi+angleinc) and (DECBASE-1);
	UPARROW:		camtheta:=(camtheta+angleinc) and (DECBASE-1);
	DOWNARROW:	camtheta:=(camtheta-angleinc) and (DECBASE-1);
	HOMEKEY:		camalpha:=(camalpha-angleinc) and (DECBASE-1);
	ENDKEY:		camalpha:=(camalpha+angleinc) and (DECBASE-1);
	end;
	if repstate=0 then camcmd:=0;

	SetCameraP(camsolid,camalpha,camtheta,camphi,camfocal,camr);
	SetLuminosity(lumtheta,lumphi,round(DECBASE*5/6),round(DECBASE*1/6));
end;






procedure StartAnim(GDriver:integer;pr:TSolidProc);
var	e,i:integer;
	s:string;

const
	D=64;
begin
	directvideo:=false;
	ZInitGraph(GDriver);
	ZGetModeInfo(xscr,yscr,ratiox,ratioy,xtext,ytext,nbcolor);
	MakePal;
	NoMouse:=InitMouse;

	SO[0].free:=0;
	for i:=1 to NBSOLID-1 do SO[i].free:=1;
	getmem(PFO,sizeof(pointer)*NBFIMAX);
	InitSinTable;
	csolid:=0;
	time:=0;



	lumphi:=-(DECBASE div 8);
	lumtheta:=(DECBASE div 8);


	camalpha:=0;
	camphi:=0;
	camtheta:=0;
	camcmd:=0;
	OldMouseX:=MouseX;
	OldMouseY:=MouseY;
	camr:=500;
	camfocal:=300;
	camsolid:=0;
	imfreq:=1;

	angleinc:=DECBASE div 36;
	distinc:=100;
	k:=0;
	estate:=1;
	fstate:=0;
	oldestate:=0;
	repstate:=1;
	nbfi:=0;

	repeat
		ti:=FTimer;
		e:=pr(time);
		TestKey;
          DrawPage;
		ti:=FTimer-ti;
		if ti=0 then ti:=1;
		imfreq:=round(1/ti*18.2);
		inc(time);
	until (fstate<>0);

	freemem(PFO,sizeof(pointer)*NBFIMAX);
	ZCloseGraph;
end;

end.


