{    ZGRAPH (c) 1991,1992 Fabrice Bellard Version 2.0
	TAB=5 SPACES
	Driver graphique spcialement conu pour les animations plein cran
	avec commutation de page. Si le mode ne possde pas de commutation de
	page, l'utilisateur n'a pas a s'en soucier.

	Reste  faire:
		- FillC pour EGA
		- Tests de sortie corrects en Y pour ZFillPolyC
		- Test de sortie d'cran pour ZOutText
		- Pour Trident: trac de point, ligne et correction scintillement swapping de page

}
{$S-,R-,N-,G-}
Unit ZGraph;

interface

uses dos;

const
	Z_EGA=0;			{ 640x350 en 16 couleurs, 2 pages }
	Z_MCGA=1;			{ 320x200x256, 1 page }
	Z_TRI640x400=2;	{ Trident 640x400x256, 2 pages }

procedure ZInitGraph(GDriver:integer);
procedure ZGetModeInfo(var xs,ys,ratioX,ratioY,xt,yt,nbcolor:integer);	{ ratio= nb_pts/mm*256 }
procedure ZCloseGraph;
procedure ZSetViewPort(x1,y1,xs,ys:integer);
procedure ZGetViewPort(var x1,y1,xs,ys:integer);
procedure ZView;
procedure ZClearViewPort(color:word);
procedure ZInitPal(var pal;startpal,nbpal:word);
procedure Zplot(x,y:integer;color:word);				{ point (avec tests) }
procedure ZLine(x1,y1,x2,y2:integer;color:word);			{ ligne (avec test de sortie) }
procedure ZOutText(x,y,cc,cf:integer;s:string);
procedure ZFillPoly(NumP:integer;var tab;color:word);  { polygone CONVEXE (avec tests) }

{	remplissage d'un polygone avec interpolation linaire de la couleur:
	tabp contient NumP enregistrements: x:integer,y:integer,color:word
}
procedure ZFillPolyC(NumP:integer;var tabp);

implementation

const
	MAXLINE=480;

type
	dw=record l,h:word end;
var
	ZXScr,ZYScr,ZXsize,ZYSize:integer;
	gdrv:word;

	{ ces variables sont mises en place par le driver }
	NBColorScr,ZXSizeScr,ZYSizeScr:word;
	RatioXScr,RatioYScr:integer;
	ZXText,ZYText:word;
	TextProc,PlotProc,CloseProc,TrfProc,LineProc,FillProc,FillCProc:procedure;

{ pour les polygones }
	ZPMinMaxX:array[0..3*(MAXLINE+10)-1] of integer;

{ ******************************************************************* }
{ Driver EGA }
{ ******************************************************************* }

var
	EGAPageOfs:word;

procedure EGAClear; assembler;
asm
	cld
	mov	dx,3CEh
	mov	ax,00000h
	out	dx,ax
	mov	ax,0FF01h
	out	dx,ax
	mov	ax,0FF08h
	out	dx,ax
	mov ax,0A000h
	mov es,ax
	mov di,EGAPageOfs
	xor ax,ax
	mov cx,640*350/8/2
	rep stosw
end;


{	ax=x
	bx=y
	cx=color
}
procedure EGAPlot; far; assembler;
asm
		mov ch,cl
		mov	cl,4
		shl	bx,cl
		mov	di,bx
		shl	bx,1
		shl	bx,1
		add	di,bx
		add	di,EGAPageOfs
		mov	cl,al
		and	cl,7
		shr	ax,1
		shr	ax,1
		shr	ax,1
		add	di,ax
		mov	dx,3CEh
		mov	ax,205h
		out	dx,ax
		mov	ax,8008h
		shr	ah,cl
		out	dx,ax
		mov	ax,0A000h
		mov	es,ax
		xchg	ch,es:[di]
		inc	dx
		mov	al,0FFh
		out	dx,al
		dec	dx
		mov	ax,5
		out	dx,ax
end;

{	dx=x1
	ax=y1
	bx=x2
	si=y2
	cx=color
}
procedure EGALine; far; assembler;
asm
		push cx
		cmp	si,ax
		jge	@l1
		xchg si,ax
		xchg bx,dx
@l1:
		sub	si,ax
		sub	bx,dx
		mov	cl,4
		shl	ax,cl
		mov	di,ax
		shl	ax,1
		shl	ax,1
		add	di,ax
		mov  ax,dx
		mov	cl,3
		shr	ax,cl
		mov	cl,dl
		and	cl,7
		add	di,ax
		add	di,EGAPageOfs
		pop ax
		mov	dx,3CEh
		mov	ah,al
		mov	al,0
		out	dx,ax
		mov	ax,0FF01h
		out	dx,ax
		mov	al,8
		out	dx,al
		inc	dx
		push	ds
		mov	ax,0A000h
		mov	ds,ax
		mov	al,80h
		shr	al,cl
		or	bx,bx
		js	@loc_25
		cmp	bx,si
		jb	@loc_22
		mov	cx,bx
		inc	cx
		shl	si,1
		mov	bp,si
		sub	bp,bx
		shl	bx,1
		sub	si,bx
		add	bx,si
		mov	ah,al
		sub	al,al
@locloop_18:
		or	al,ah
		and	bp,bp
		jns	@loc_20
		add	bp,bx
		ror	ah,1
		jnc	@loc_19
		out	dx,al
		xchg	al,[di]
		inc	di
		sub	al,al
@loc_19:
		loop	@locloop_18
		jmp	@loc_21
@loc_20:
		out	dx,al
		xchg	al,[di]
		sub	al,al
		add	di,50h
		add	bp,si
		ror	ah,1
		adc	di,0
		loop	@locloop_18
@loc_21:
		out	dx,al
		xchg	al,[di]
		jmp	@loc_33


@loc_22:
		mov	cx,si
		inc	cx
		shl	bx,1
		mov	bp,bx
		sub	bp,si
		shl	si,1
		sub	bx,si
		add	si,bx
		out	dx,al
  
@locloop_23:
		xchg	ah,[di]
		and	bp,bp
		jns	@loc_24
		add	bp,si
		add	di,50h
		loop	@locloop_23
		jmp	@loc_33
@loc_24:
		ror	al,1
		adc	di,0
		out	dx,al
		add	bp,bx
		add	di,50h
		loop	@locloop_23
		jmp	@loc_33

@loc_25:
		neg	bx
		cmp	bx,si
		jb	@loc_30
		mov	cx,bx
		inc	cx
		shl	si,1
		mov	bp,si
		sub	bp,bx
		shl	bx,1
		sub	si,bx
		add	bx,si
		mov	ah,al
		sub	al,al
  
@locloop_26:
		or	al,ah
		and	bp,bp
		jns	@loc_28
		add	bp,bx
		rol	ah,1
		jnc	@loc_27
		out	dx,al
		xchg	al,[di]
		dec	di
		sub	al,al
@loc_27:
		loop	@locloop_26

		jmp	@loc_29
@loc_28:
		out	dx,al
		xchg	al,[di]
		sub	al,al
		add	di,50h
		add	bp,si
		rol	ah,1
		sbb	di,0
		loop	@locloop_26
@loc_29:
		out	dx,al
		xchg	al,[di]
		jmp	@loc_33
@loc_30:
		mov	cx,si
		inc	cx
		shl	bx,1
		mov	bp,bx
		sub	bp,si
		shl	si,1
		sub	bx,si
		add	si,bx
		out	dx,al

@locloop_31:
		xchg	ah,[di]
		and	bp,bp
		jns	@loc_32
		add	bp,si
		add	di,50h
		loop	@locloop_31
		jmp	@loc_33
@loc_32:
		rol	al,1
		sbb	di,0
		out	dx,al
		add	bp,bx
		add	di,50h
		loop	@locloop_31
@loc_33:
		mov	al,0FFh
		out	dx,al
		dec	dx
		mov	ax,1
		out	dx,ax
		pop	ds
@fin:
end;

{
  si=buf
  di=ligne de dpart
  bx=nombre de lignes
  dx=color
}
procedure EGAFill; far; assembler;
asm
	cld
	mov ah,dl
	mov dx,3CEh
	mov al,0
	out dx,ax
	mov ax,0FF01h
	out dx,ax
	mov al,8
	out dx,al
	inc dx

	mov cl,4
	shl di,cl
	mov ax,di
	shl di,1
	shl di,1
	add di,ax
	add di,EGAPageOfs
	mov ax,0A000h
	mov es,ax
	mov cx,bx

@hlstart:
	push cx
	lodsw
	mov bx,ax
	lodsw
	mov bp,ax
	mov cl,bl
	and cl,7
	mov ax,07FFFh
	shr al,cl
	mov cx,bp
	and cl,7
	shr ah,cl
	not ah
	mov cl,3
	shr bx,cl
	shr bp,cl
	add di,bx
	mov cx,bp
	sub cx,bx
	jl @hlfinline
	je @hl10
	dec cx
	out dx,al
	xchg al,es:[di]
	inc di
	mov al,0FFh
	out dx,al
	rep stosb
	mov al,ah
	out dx,al
	xchg al,es:[di]
	sub di,bp
	add di,80
     pop cx
	loop @hlstart
	jmp @hlfin
@hl10:
	and al,ah
	out dx,al
	xchg al,es:[di]
	sub di,bp
	add di,80
	pop cx
	loop @hlstart
	jmp @hlfin
@hlfinline:
	sub di,bx
	add di,80
	pop cx
	loop @hlstart
@hlfin:
	mov al,0FFh
	out dx,al
	dec dx
	mov ax,0001h
	out dx,ax
end;


procedure EGAFillC; far; assembler;
asm
end;




procedure EGATrf; far;
var adr:word;
begin
	adr:=EGAPageOfs;

	asm
		{ wait synchro VBL }
		mov dx,3DAh
@1:
		in al,dx
		and al,8
		jz @1

		mov cx,2500
@2:
		loop @2

		{ changement de page }
		mov dx,3D4h
		mov bx,adr
          mov al,0Dh
		mov ah,bl
		out dx,ax
          mov al,0Ch
		mov ah,bh
		out dx,ax
	end;

	EGAPageOfs:=$8000-adr;
	EGAClear;
end;

procedure Font8x14; external;
{$L font8x14 }


{	ax=x
	si=y
	bl= cc bh=cf
	dx= char
}
procedure EGAText; far; assembler;
asm
	cld
	mov cx,dx
	mov di,ax
	mov ax,80*14
	mul si
	add di,ax
	add di,EGAPageOfs
	mov ax,0A000h
	mov es,ax

	mov dx,cx
	shl dx,1
	mov si,dx
	mov cl,3
	shl si,cl
	sub si,dx
	add si,offset Font8x14

	mov dx,3CEh
	mov ah,bl
	mov al,0
	out dx,ax
	mov ax,0FF01h
	out dx,ax
	mov al,8
	out dx,al
	inc dx
	mov cx,14
@1:
	mov al,cs:[si]
	inc si
	out dx,al
	xchg es:[di],al
	add di,80
	loop @1
	sub di,80*14
	sub si,14
     dec dx

	mov ah,bh
	mov al,0
	out dx,ax
	mov al,8
	out dx,al
	inc dx
	mov cx,14
@2:
	mov al,cs:[si]
	inc si
	not al
	out dx,al
	xchg es:[di],al
	add di,80
	loop @2

	mov al,0FFh
	out dx,al
	dec dx
	mov ax,0001h
	out dx,ax
end;


procedure EGAClose; far;
begin
	asm
		mov ax,3
		int 10h
	end;
end;

procedure EGAInit; far;
var	i:integer;
	reg:registers;
begin
	reg.AX:=$10;
	intr($10,reg);
	for i:=0 to 15 do begin
		reg.AX:=$1000;
		reg.BL:=i;
		reg.BH:=i;
		intr($10,reg);
	end;
	EGAPageOfs:=$8000;
	EGAClear;
	ZXSizeScr:=640;
	ZYSizeScr:=350;
	NBColorScr:=16;
	ZXText:=8;
	ZYText:=14;
	RatioXScr:=640;
	RatioYScr:=497;
	@CloseProc:=@EGAClose;
     @TrfProc:=@EGATrf;
	@PlotProc:=@EGAPlot;
	@LineProc:=@EGALine;
	@FillProc:=@EGAFill;
	@TextProc:=@EGAText;
	@FillCProc:=@EGAFillC;
end;



{ ******************************************************************* }
{ Driver MCA }
{ ******************************************************************* }

const
	MCGASIZE=64016;
var
	mcgaseg:word;
	mcgaptr:pointer;


procedure FillWord(var tab;count:word;w:integer); assembler;
asm
	les di,tab
	mov cx,count
	mov ax,w
	rep stosw
end;


procedure MCGATrf; far; assembler;
asm
	cld
	push ds
	mov ax,0A000h
	mov es,ax
	xor di,di
     mov ds,mcgaseg
	xor si,si
	mov cx,32000
	rep movsw
	pop ds
	mov es,mcgaseg
	xor di,di
	mov cx,32000
	xor ax,ax
	rep stosw
end;


{	dx=x1
	ax=y1
	bx=x2
	si=y2
	cx=color
}
procedure MCGALine; far; assembler;
asm
		mov ch,cl
		cmp	si,ax
		jge	@l1
		xchg si,ax
		xchg bx,dx
@l1:
		sub	si,ax
		sub	bx,dx
		mov	cl,6
		shl	ax,cl
		mov	di,ax
		shl	ax,1
		shl	ax,1
		add	di,ax
		add	di,dx
		mov al,ch

		push	ds
		mov	ds,mcgaseg
		or	bx,bx
		js	@loc_25
		cmp	bx,si
		jb	@loc_22
		mov	cx,bx
		inc	cx
		shl	si,1
		mov	bp,si
		sub	bp,bx
		shl	bx,1
		sub	si,bx
		add	bx,si
@locloop_18:
		mov [di],al
		and	bp,bp
		jns	@loc_20
		add	bp,bx
		inc di
		loop	@locloop_18
		jmp	@loc_21
@loc_20:
		add di,321
		add bp,si
		loop	@locloop_18
@loc_21:
		jmp	@loc_33
@loc_22:
		mov	cx,si
		inc	cx
		shl	bx,1
		mov	bp,bx
		sub	bp,si
		shl	si,1
		sub	bx,si
		add	si,bx
@locloop_23:
		mov [di],al
		and	bp,bp
		jns	@loc_24
		add	bp,si
		add	di,320
		loop	@locloop_23
		jmp	@loc_33
@loc_24:
		add di,321
		add bp,bx
		loop	@locloop_23
		jmp	@loc_33

@loc_25:
		neg	bx
		cmp	bx,si
		jb	@loc_30
		mov	cx,bx
		inc	cx
		shl	si,1
		mov	bp,si
		sub	bp,bx
		shl	bx,1
		sub	si,bx
		add	bx,si
@locloop_26:
		mov [di],al
		and	bp,bp
		jns	@loc_28
		add	bp,bx
		dec	di
		loop	@locloop_26
		jmp	@loc_33
@loc_28:
		add di,319
		add	bp,si
		loop	@locloop_26
		jmp	@loc_33
@loc_30:
		mov	cx,si
		inc	cx
		shl	bx,1
		mov	bp,bx
		sub	bp,si
		shl	si,1
		sub	bx,si
		add	si,bx
@locloop_31:
		mov [di],al
		and	bp,bp
		jns	@loc_32
		add	bp,si
		add di,320
		loop	@locloop_31
		jmp	@loc_33
@loc_32:
		add di,319
		add	bp,bx
		loop	@locloop_31
@loc_33:
		pop	ds
end;

{	ax=x
	bx=y
	cx=color
}
procedure MCGAPlot; far; assembler;
asm
	mov cl,6
	shl bx,cl
	mov di,bx
	shl bx,1
	shl bx,1
	add di,bx
	add di,ax
	mov es,mcgaseg
	mov es:[di],cl
end;


{
  si=buf qui contient: xstart,xend
  di=ligne de dpart
  bx=nombre de lignes
  dx=color
}
procedure MCGAFill; far; assembler;
asm
	cld
	mov cl,6
	shl di,cl
	mov ax,di
	shl ax,1
	shl ax,1
	add di,ax
	mov es,mcgaseg
@1:
	push di
	lodsw
     add di,ax
	mov cx,ax
	lodsw
	sub ax,cx
	js @nextl
	inc ax
	mov cx,ax
	mov al,dl
	rep stosb
@nextl:
	pop di
	add di,320
	dec bx
	jne @1
end;


{
  si=buf qui contient: xstart,xend,hi:colorend lo:colorstart
  di=ligne de dpart
  bx=nombre de lignes
}
procedure MCGAFillC; far; assembler;
asm
	cld
	mov cl,6
	shl di,cl
	mov ax,di
	shl ax,1
	shl ax,1
	add di,ax
	mov es,mcgaseg
@1:
	push di
	lodsw
     add di,ax
	mov cx,ax
	lodsw
	sub ax,cx
	mov cx,ax
	lodsw
	js @nextl
	jcxz @04
	mov bp,ax
	xor dx,dx
	sub ah,al
	mov al,0
	sbb dx,0
	idiv cx
	mov dx,ax
	mov ax,bp
	mov ah,80h
@04:
	inc cx
@05:
	stosb
	add ah,dl
	adc al,dh
	loop @05
@nextl:
	pop di
	add di,320
	dec bx
	jne @1
end;

procedure Font8x8; external;
{$L FONT8x8 }

{	ax=x
	si=y
	bl= cc bh=cf
	dx= char
}
procedure MCGAText; far; assembler;
asm
	cld
	mov cl,9
	shl si,cl
	mov di,si
	shl si,1
	shl si,1
	add di,si
	mov cl,3
	shl ax,cl
	add di,ax
     mov es,mcgaseg
	shl dx,cl
	mov si,dx
	add si,offset Font8x8
	mov dh,8
@1:
	mov ah,cs:[si]
	inc si
	mov dl,8
@2:
	mov al,bh
	shl ah,1
	jnc @3
	mov al,bl
@3:
     stosb
	dec dl
	jne @2
     add di,320-8
	dec dh
	jne @1
end;


procedure MCGAClose; far;
begin
	asm
		mov ax,3
		int 10h
	end;
	freemem(mcgaptr,MCGASIZE);
end;

procedure MCGAInit; far;
begin
	asm
		mov ax,13h
		int 10h
	end;
	getmem(mcgaptr,MCGASIZE);
	mcgaseg:=dw(mcgaptr).h+1;
	FillWord(ptr(mcgaseg,0)^,32000,0);
	ZXSizeScr:=320;
	ZYSizeScr:=200;
	NBColorScr:=256;
	ZXText:=8;
	ZYText:=8;
	RatioXScr:=330;
	RatioYScr:=277;
	@CloseProc:=@MCGAClose;
	@PlotProc:=@MCGAPlot;
	@LineProc:=@MCGALine;
	@FillProc:=@MCGAFill;
     @TrfProc:=@MCGATrf;
	@TextProc:=@MCGAText;
	@FillCProc:=@MCGAFillC;
end;



{ ******************************************************************* }
{ Driver Trident 640x400 256 couleurs }
{ ******************************************************************* }

var
	TRIOfs:word;
	tripage,curbank:byte;

procedure initbank; assembler;
asm
		cli
        mov     dx,3ceh         {set page size to 64k}
        mov     al,6
        out     dx,al
        inc     dl
        in      al,dx
        dec     dl
        or      al,4
        mov     ah,al
        mov     al,6
        out     dx,ax
                
        mov     dl,0c4h         {switch to BPS mode}
        mov     al,0bh
        out     dx,al
        inc     dl
        in      al,dx
        dec     dl
		sti
end;

{ mets la bank curbank en place }
procedure SetBank; assembler;
asm
	push ax
	push dx
	mov ah,curbank
	xor     ah,2
	mov     al,0eh
	mov     dx,3c4h
	out     dx,ax
	pop dx
	pop ax
end;

{
procedure TriClear; assembler;
asm
	mov dx,3C4h
	mov ax,0604h
	out dx,ax

	mov dx,3c4h
	mov ah,TRIPage
	or ah,ah
	je @1
	mov ah,1
@1:
	xor ah,2
	mov al,0eh
	out dx,ax

	mov ax,0A000h
	mov es,ax
     xor di,di
	mov cx,8000h
	xor ax,ax
	rep stosw

	mov dx,3C4h
	mov ax,0E04h
	out dx,ax
end;
}

procedure TriClear; assembler;
asm
	mov al,TRIPage
	or al,al
	je @2
	mov al,4
@2:
	mov curbank,al
	mov bx,4
@1:
	call setbank
	mov ax,0A000h
	mov es,ax
     xor di,di
	mov cx,8000h
	xor ax,ax
	rep stosw
	inc curbank
	dec bx
	jne @1
end;



procedure TRITrf; far;
var k:word;
begin
     if TRIPage=0 then begin
		TRIPage:=3;
		TRIOfs:=$FFFC;
		k:=0;
	end
	else begin
		TRIPage:=0;
		TRIOfs:=0;
		k:=$FFFF;
	end;

	asm
		{ wait synchro VBL }
		mov dx,3DAh
@1:
		in al,dx
		and al,8
		jz @1


		{ changement de page }
		mov dx,3D4h
		mov bx,k
          mov al,0Dh
		mov ah,bl
		out dx,ax
          mov al,0Ch
		mov ah,bh
		out dx,ax
	end;

	TRIClear;
end;

{
  si=buf qui contient: xstart,xend
  di=ligne de dpart
  bx=nombre de lignes
  dx=color
}

procedure TRIFill; far; assembler;
asm
	cld
	push dx
	mov ax,640
	mul di
	add ax,TRIOfs
	adc dl,TRIPage
	mov curbank,dl
	mov di,ax
	call setbank
	pop dx
	mov ax,0A000h
	mov es,ax
@1:
	push di
	add di,640
	jc @prob
@noprob:
	sub di,640
	lodsw
     add di,ax
@noprob_05:
	mov cx,ax
	lodsw
	sub ax,cx
	js @nextl
	inc ax
	mov cx,ax
	mov al,dl
@noprob_10:
	rep stosb
@nextl:
	pop di
	add di,640
	dec bx
	jne @1
	jmp @fin

@prob:
	sub di,640
	lodsw
	add di,ax
	jnc @prob_05
	inc curbank
	call setbank
	jmp @noprob_05
@prob_05:
	mov cx,ax
	lodsw
	sub ax,cx
	js @prob_20
	inc ax
	mov cx,ax
	mov al,dl
@prob_10:
	mov es:[di],al
	inc di
	jne @prob_15
	inc curbank
	call setbank
	dec cx
	jmp @noprob_10
@prob_15:
	loop @prob_10
@prob_20:
	inc curbank
	call setbank
	jmp @nextl
@fin:
end;

procedure TriFillC; far; assembler;
asm
	cld
	mov ax,640
	mul di
	add ax,TRIOfs
	adc dl,TRIPage
	mov curbank,dl
	mov di,ax
	call setbank
	mov ax,0A000h
	mov es,ax
@1:
	push di
	lodsw
     add di,ax
	jnc @10
	inc curbank
	call setbank
@10:
	mov cx,ax
	lodsw
	sub ax,cx
	mov cx,ax
	lodsw
	js @nextl
	jcxz @04
	mov bp,ax
	xor dx,dx
	sub ah,al
	mov al,0
	sbb dx,0
	idiv cx
	mov dx,ax
	mov ax,bp
	mov ah,80h
@04:
	inc cx
	add di,cx
	jc @prob_01
	sub di,cx
@05:
	stosb
	add ah,dl
	adc al,dh
	loop @05
@nextl:
	pop ax
	sub ax,di
	add ax,640
	add di,ax
	jnc @25
	inc curbank
	call setbank
@25:
	dec bx
	jne @1
	jmp @fin
@prob_01:
     sub di,cx
@20:
	mov es:[di],al
	inc di
	jne @21
	inc curbank
	call setbank
@21:
     add ah,dl
	adc al,dh
	loop @20
	jmp @nextl
@fin:
end;


{	ax=x
	si=y
	bl= cc bh=cf
	dx= char
}
procedure TRIText; far; assembler;
asm
	cld
	push dx
	mov cl,3
	shl ax,cl
	mov di,ax
	mov ax,640*14
	mul si
	add ax,TRIOfs
	adc dl,TRIPage
	add di,ax
	adc dl,0
	mov curbank,dl
	call setbank
	pop dx
	mov ax,0A000h
     mov es,ax

	shl dx,1
	mov si,dx
	mov cl,3
	shl si,cl
	sub si,dx
	add si,offset Font8x14
	mov dh,14
@1:
	mov ah,cs:[si]
	inc si
	mov dl,8
@2:
	mov al,bh
	shl ah,1
	jnc @3
	mov al,bl
@3:
	mov es:[di],al
	inc di
	jne @noprob_05
	inc curbank
	call setbank
@noprob_05:
	dec dl
	jne @2
     add di,640-8
	jnc @noprob_10
	inc curbank
	call setbank
@noprob_10:
	dec dh
	jne @1
end;


procedure TRIPlot; far;
begin
end;

procedure TRILine; far;
begin
end;


procedure TRIClose; far; assembler;
asm
	mov ax,3
	int 10h
end;

procedure TRIInit; far;
begin
	asm
		mov ax,5Ch
		int 10h
	end;
	initbank;
	ZXSizeScr:=640;
	ZYSizeScr:=400;
	NBColorScr:=256;
	ZXText:=8;
	ZYText:=14;
	RatioXScr:=640;
	RatioYScr:=557;
	@CloseProc:=@TRIClose;
	@PlotProc:=@TRIPlot;
	@LineProc:=@TRILine;
	@FillProc:=@TRIFill;
     @TrfProc:=@TRITrf;
	@TextProc:=@TRIText;
	@FillCproc:=@TRIFillC;

	TRIPage:=3;
	TRIOfs:=$FFFC;
	TRIClear;
end;





{ ******************************************************************* }
{ Fonctions graphiques }
{ ******************************************************************* }

procedure ZInitGraph(GDriver:integer);
begin
	case GDriver of
	Z_EGA: EGAInit;
	Z_MCGA: MCGAInit;
	Z_TRI640x400: TRIInit;
	end;
	ZXScr:=0;
	ZYScr:=0;
	ZXSize:=ZXSizeScr;
	ZYSize:=ZYSizeScr;
end;

procedure ZCloseGraph;
begin
	CloseProc;
end;

procedure ZGetModeInfo(var xs,ys,ratioX,ratioY,xt,yt,nbcolor:integer);
begin
	xs:=ZXSizeScr;
	ys:=ZYSizeScr;
	RatioX:=RatioXScr;
	RatioY:=RatioYScr;
	xt:=ZXText;
	yt:=ZYtext;
	nbcolor:=NbColorScr;
end;

procedure ZInitPal(var pal;startpal,nbpal:word);
var reg:registers;
	i:word;
begin
     reg.AX:=$1012;
     reg.BX:=startpal;
     reg.CX:=nbpal;
     reg.DX:=ofs(pal);
     reg.ES:=seg(pal);
     intr($10,reg);
end;

procedure ZGetViewPort(var x1,y1,xs,ys:integer);
begin
	x1:=ZXScr;
	y1:=ZYScr;
	xs:=ZXSize;
	ys:=ZYSize;
end;

procedure ZSetViewPort(x1,y1,xs,ys:integer);
var x2,y2:integer;
begin
	x2:=x1+xs-1;
	y2:=y1+ys-1;
	if (x1>=ZXSizeScr) or (y1>=ZYSizeScr)
		or (x2>=ZXSizeScr) or (y2>=ZYSizeScr) then exit;
	ZXScr:=x1;
	ZYScr:=y1;
	ZXSize:=xs;
	ZYSize:=ys;
end;

procedure Zplot(x,y:integer;color:word); assembler;
asm
		mov	ax,X
		or ax,ax
		jl @fin
		cmp ax,ZXSize
		jge @fin
		add ax,ZXScr

		mov	bx,Y
		or bx,bx
     	jl @fin
		cmp bx,ZYSize
		jge @fin
		add bx,ZYScr

		mov cx,color

		call PlotProc
@fin:
end;

procedure ZLine(x1,y1,x2,y2:integer;color:word); assembler;
asm
	mov	cx,x1
	mov	di,y1
	mov	si,y2
	mov	bx,x2

	cmp si,di
	jge @1
	xchg bx,cx
	xchg si,di
@1:
	{ test de sortie grossire }
	or si,si
	jl @lfin
     cmp di,ZYSize
	jge @lfin

	or bx,bx
	jge @2
	or cx,cx
	jl @lfin
@2:
     cmp bx,ZXSize
	jl @3
	cmp cx,ZXSize
	jge @lfin
@3:
	{ si y1<0 }
	or di,di
	jge @10
	mov ax,bx
	sub ax,cx
	imul di
	sub di,si
	idiv di
	add cx,ax
	xor di,di
@10:
	{ si y2>=ZYSize }
	cmp si,ZYSize
	jl @20
	mov ax,bx
	sub ax,cx
	mov dx,ZYSize
	dec dx
	sub dx,di
	imul dx
	sub si,di
	idiv si
     add ax,cx
     mov bx,ax
	mov si,ZYSize
	dec si
@20:

	cmp bx,cx
     jge @25
	xchg bx,cx
	xchg si,di
@25:
	or bx,bx
	jl @lfin
	cmp cx,ZXSize
	jge @lfin
	{ si x1<0 }
	or cx,cx
	jge @30
	mov ax,si
	sub ax,di
	imul cx
	sub cx,bx
	idiv cx
     add di,ax
	xor cx,cx
@30:
	{ si x2>=ZXSize }
	cmp bx,ZXSize
	jl @40
     mov ax,si
	sub ax,di
	mov dx,ZXSize
	dec dx
	sub dx,cx
	imul dx
	sub bx,cx
	idiv bx
     add ax,di
	mov si,ax
     mov bx,ZXSize
	dec bx
@40:
	add cx,ZXScr
	mov dx,cx
	add bx,ZXScr
	add di,ZYScr
	mov ax,di
	add si,ZYScr
	mov cx,color
	call LineProc
@lfin:
end;

procedure ZView;
begin
	TrfProc;
end;

procedure ZClearViewPort(color:word);
var tab:array[0..3] of record x,y:integer end;
begin
     with tab[0] do begin x:=0; y:=0 end;
     with tab[1] do begin x:=ZXSize-1; y:=0 end;
     with tab[2] do begin x:=ZXSize-1; y:=ZYSize-1 end;
     with tab[3] do begin x:=0; y:=ZYSize-1 end;
	ZFillPoly(4,tab,color);
end;

procedure ZOutText(x,y,cc,cf:integer;s:string);
var	i:integer;
	c:char;
begin
	for i:=1 to length(s) do begin
		c:=s[i];
		asm
			mov ax,x
			add ax,i
			dec ax
			mov si,y
			mov bl,byte[cc]
			mov bh,byte[cf]
			mov dl,c
			mov dh,0
			call TextProc
		end;
	end;
end;



{ trac d'un polygone }

var 	NP,Ystart,Ystart1,Ylen,ZPLineOfs:integer;
	PTab:pointer;
     PColor:word;

{ trac d'une ligne sans tests:
	bp=x1
	di=y1
	dx=x2
	bx=y2
	registres non modifis: es
}
procedure ZPLine; assembler;
asm
	add bp,ZXScr
	add di,ZYScr
	add dx,ZXScr
	add bx,ZYScr
	cmp bx,di
	jge @plinelim5
	xchg bx,di
	xchg bp,dx
@plinelim5:
	sub bx,di
	je @plinenul
	shl di,1
	shl di,1
	add di,offset ZPMinMaxX
	sub dx,bp
	jl @pline_xdec

@pline_xinc:
	cmp dx,bx
	ja @pline_xinc2
@pline_xinc1:
	mov cx,bx
	inc cx
	mov ax,bx
	neg ax
	shl bx,1
	shl dx,1
@pline03:
	cmp bp,[di]
	jg @pline05
	mov [di],bp
@pline05:
	cmp bp,[di+2]
	jl @pline10
	mov [di+2],bp
@pline10:
	add di,4
	add ax,dx
     js @pline07
	inc bp
	sub ax,bx
@pline07:
	loop @pline03
	jmp @plinefin

@pline_xinc2:
	mov cx,dx
	inc cx
     mov ax,dx
	neg ax
     shl bx,1
	shl dx,1
	sub dx,bx
@pline15:
     cmp bp,[di]
     jg @pline16
	mov [di],bp
@pline16:
     add ax,dx
	js @pline17
@pline19:
	dec cx
	je @pline17
	inc bp
	sub ax,bx
	jns @pline19
@pline17:
     cmp bp,[di+2]
	jl @pline18
	mov [di+2],bp
@pline18:
	inc bp
	add di,4
	dec cx
	jg @pline15
	jmp @plinefin

@pline_xdec:
	neg dx
	cmp dx,bx
	ja @pline_xdec2
@pline_xdec1:
	mov cx,bx
	inc cx
	mov ax,bx
	neg ax
	shl bx,1
	shl dx,1
@pline33:
	cmp bp,[di]
	jg @pline35
	mov [di],bp
@pline35:
	cmp bp,[di+2]
	jl @pline40
	mov [di+2],bp
@pline40:
	add di,4
	add ax,dx
     js @pline37
	dec bp
	sub ax,bx
@pline37:
	loop @pline33
	jmp @plinefin

@pline_xdec2:
	mov cx,dx
	inc cx
     mov ax,dx
	neg ax
     shl bx,1
	shl dx,1
	sub dx,bx
@pline45:
     cmp bp,[di+2]
	jl @pline48
	mov [di+2],bp
@pline48:
     add ax,dx
	js @pline47
@pline49:
	dec cx
	je @pline47
	dec bp
	sub ax,bx
	jns @pline49
@pline47:
     cmp bp,[di]
     jg @pline46
	mov [di],bp
@pline46:
	dec bp
	add di,4
	dec cx
	jg @pline45
	jmp @plinefin

@plinenul:
	shl di,1
	shl di,1
	add di,offset ZPMinMaxX
	cmp dx,bp
	jge @plinenul05
	xchg dx,bp
@plinenul05:
	cmp bp,[di]
	jg @pline05c
	mov [di],bp
@pline05c:
	cmp dx,[di+2]
	jl @pline10c
	mov [di+2],dx
@pline10c:

@plinefin:
end;

{ trac d'une ligne avec tests de sortie en Y:
	bp=x1
	di=y1
	dx=x2
	bx=y2
}
procedure ZPLineTest; assembler;
asm
	cmp bx,di
	jge @plinet05
	xchg bx,di
	xchg bp,dx
@plinet05:
	or bx,bx
	jl @plinetfin
	cmp di,ZYSize
	jge @plinetfin

	or di,di
	jge @plinet10
	push dx
	mov ax,dx
	sub ax,bp
	imul di
	mov cx,di
	sub cx,bx
	idiv cx
	add bp,ax
	xor di,di
	pop dx
@plinet10:

	cmp bx,ZYSize
	jl @plinet20
	mov ax,dx
	sub ax,bp
	mov cx,ZYSize
	dec cx
	sub cx,di
     imul cx
	mov cx,bx
	sub cx,di
	idiv cx
	add ax,bp
	mov dx,ax
     mov bx,ZYSize
	dec bx
@plinet20:
	call ZPLine
@plinetfin:
end;



procedure ZFillPoly(NumP:integer;var tab;color:word); assembler;
asm
	cld
	mov cx,NumP
	les bx,tab
	mov dx,color
	push bp

@polygone:
	mov NP,cx
	mov word ptr [PTab],bx
	mov word ptr [PTab+2],es
     mov PColor,dx
	or cx,cx
	jne @poly05
@polyfin1:
	jmp @polyfin
@poly05:

	push ds
	lds si,Ptab
	mov bx,32000
	mov dx,-32000
	mov di,32000
	mov bp,-32000
@poly1:
	lodsw
	cmp ax,di
     jge @poly4
	mov di,ax
@poly4:
	cmp ax,bp
	jle @poly5
	mov bp,ax
@poly5:
	lodsw
	cmp ax,bx
	jge @poly2
	mov bx,ax
@poly2:
	cmp ax,dx
	jle @poly3
	mov dx,ax
@poly3:
	loop @poly1
	mov ax,bp
	pop ds

	cmp	bx,ZYSize
	jge	@polyfin1
	or	dx,dx
	jl	@polyfin1
     cmp	di,ZXSize
	jge	@polyfin1
	or	ax,ax
	jl	@polyfin1

     or	bx,bx
	jl	@polytest
     cmp	dx,ZYSize
	jge	@polytest
	or	di,di
	jl	@poly41
	cmp	ax,ZXSize
	jge	@poly41
	mov	ZPLineOfs,offset ZPLine
	jmp @poly8
@polytest:
	or bx,bx
	jge @poly40
	xor bx,bx
@poly40:
	cmp dx,ZYSize
	jl @poly41
	mov dx,ZYSize
	dec dx
@poly41:
	mov 	ZPLineOfs,offset ZPLineTest
@poly8:
	mov ax,ds
     mov es,ax
	mov di,offset ZPMinMaxX
	mov cx,dx
	sub cx,bx
	inc cx
	mov Ylen,cx
	add bx,ZYScr
	mov YStart,bx
     shl bx,1
	shl bx,1
	add di,bx
	mov Ystart1,di
	mov ax,32767
	mov bx,-32768
	inc cx
	shr cx,1
@poly20:
	mov [di+00],ax
	mov [di+02],bx
	mov [di+04],ax
	mov [di+06],bx
	add di,8
	loop @poly20

     les si,PTab
	mov cx,NP
	dec cx
@poly30:
	push cx
	push si
	mov bp,es:[si]
	mov di,es:[si+2]
	mov dx,es:[si+4]
	mov bx,es:[si+6]
     call ZPLineOfs
	pop si
     pop cx
	add si,4
	loop @poly30

	mov bp,es:[si]
	mov di,es:[si+2]
	mov si,word ptr PTab
     mov dx,es:[si]
	mov bx,es:[si+2]
	call ZPLineOfs

	cmp ZPLineOfs,offset ZPLineTest
	jne @poly90

	mov cx,Ylen
	mov si,Ystart1
	mov dx,ZXScr
	mov bx,ZXSize
	add bx,dx
	dec bx
@poly80:
	lodsw
	mov bp,ax
	lodsw
	cmp bp,dx
	jge @poly81
	mov [si-4],dx
@poly81:
	cmp bp,bx
	jle @poly82
@poly84:
     mov word ptr [si-4],8
	mov word ptr [si-2],0
	jmp @poly85
@poly82:
	cmp ax,bx
	jle @poly83
	mov [si-2],bx
@poly83:
	cmp ax,dx
	jl @poly84
@poly85:
	loop @poly80
@poly90:

	mov si,Ystart1
     mov di,Ystart
	mov bx,Ylen
	mov dx,PColor
	call FillProc
@polyfin:

	pop bp
end;

{ remplissage d'un polygone avec interpolation de couleur de Gouraud }

{ trac d'une ligne sans tests:
	al=startcolor
	ah=endcololor
	bp=x1
	di=y1
	dx=x2
	bx=y2
}
var
	deltay,deltax,deltac:integer;

procedure ZPLineC; assembler;
asm
	add bp,ZXScr
	add di,ZYScr
	add dx,ZXScr
	add bx,ZYScr
	cmp bx,di
	jge @plinelim5
	xchg bx,di
	xchg bp,dx
	xchg al,ah
@plinelim5:
     mov cl,ah
	mov ch,0
	sub cl,al
	sbb ch,0
	mov ah,1
	or cx,cx
	jns @pline02
	mov ah,-1
	neg cx
@pline02:
	shl cx,1
	mov deltac,cx

	sub bx,di
	mov cx,di
	shl di,1
	add di,cx
	shl di,1
	add di,offset ZPMinMaxX
	sub dx,bp
	jl @pline_xdec

@pline_xinc:
	mov cx,bx
	or cx,dx
	je @pline_null
	cmp dx,bx
	ja @pline_xinc2
@pline_xinc1:
	mov cx,bx
	inc cx
	shl dx,1
	mov deltax,dx
	mov dx,bx
	neg dx
	mov si,bx
	neg si
	shl bx,1
@pline03:
	cmp bp,[di]
	jg @pline05
	mov [di],bp
	mov [di+4],al
@pline05:
	cmp bp,[di+2]
	jl @pline10
	mov [di+2],bp
	mov [di+5],al
@pline10:
	add di,6
	add dx,deltax
     js @pline07
	inc bp
	sub dx,bx
@pline07:
	add si,deltac
	js @pline08
@pline09:
	add al,ah
	sub si,bx
	jns @pline09
@pline08:
	loop @pline03
	jmp @plinefin

@pline_xinc2:
     shl bx,1
	mov deltay,bx
	mov cx,dx
	inc cx
     mov bx,dx
	neg bx
	mov si,dx
	neg si
	shl dx,1
	mov deltax,dx
	sub dx,deltay
@pline15:
     cmp bp,[di]
     jg @pline16
	mov [di],bp
	mov [di+4],al
@pline16:
     add bx,dx
	js @pline17
@pline19:
	dec cx
	je @pline17
	inc bp
	add si,deltac
	js @pline22
@pline23:
	add al,ah
	sub si,deltax
     jns @pline23
@pline22:
	sub bx,deltay
	jns @pline19
@pline17:
     cmp bp,[di+2]
	jl @pline18
	mov [di+2],bp
	mov [di+5],al
@pline18:
	inc bp
	add si,deltac
	js @pline20
@pline21:
	add al,ah
	sub si,deltax
	jns @pline21
@pline20:
	add di,6
	dec cx
	jg @pline15
	jmp @plinefin

@pline_xdec:
	neg dx
	cmp dx,bx
	ja @pline_xdec2
@pline_xdec1:
	mov cx,bx
	inc cx
	shl dx,1
	mov deltax,dx
	mov dx,bx
	neg dx
	mov si,bx
	neg si
	shl bx,1
@plined03:
	cmp bp,[di]
	jg @plined05
	mov [di],bp
	mov [di+4],al
@plined05:
	cmp bp,[di+2]
	jl @plined10
	mov [di+2],bp
	mov [di+5],al
@plined10:
	add di,6
	add dx,deltax
     js @plined07
	dec bp
	sub dx,bx
@plined07:
	add si,deltac
	js @plined08
@plined09:
	add al,ah
	sub si,bx
	jns @plined09
@plined08:
	loop @plined03
	jmp @plinefin

@pline_xdec2:
     shl bx,1
	mov deltay,bx
	mov cx,dx
	inc cx
     mov bx,dx
	neg bx
	mov si,dx
	neg si
	shl dx,1
	mov deltax,dx
	sub dx,deltay
@plined15:
     cmp bp,[di+2]
	jl @plined18
	mov [di+2],bp
	mov [di+5],al
@plined18:
     add bx,dx
	js @plined17
@plined19:
	dec cx
	je @plined17
	dec bp
	add si,deltac
	js @plined22
@plined23:
	add al,ah
	sub si,deltax
     jns @plined23
@plined22:
	sub bx,deltay
	jns @plined19
@plined17:
     cmp bp,[di]
     jg @plined16
	mov [di],bp
	mov [di+4],al
@plined16:
	dec bp
	add si,deltac
	js @plined20
@plined21:
	add al,ah
	sub si,deltax
	jns @plined21
@plined20:
	add di,6
	dec cx
	jg @plined15
	jmp @plinefin

@pline_null:
	cmp bp,[di]
	jg @plinen05
	mov [di],bp
	mov [di+4],al
@plinen05:
	cmp bp,[di+2]
	jl @plinen10
	mov [di+2],bp
	mov [di+5],al
@plinen10:

@plinefin:
end;

{ comme ZPLine mais avec tests de sortie }
procedure ZPLineTestC; assembler;
asm
	cmp bx,di
	jge @plinet05
	xchg bx,di
	xchg bp,dx
	xchg al,ah
@plinet05:
	or bx,bx
	jl @plinetfin
	cmp di,ZYSize
	jge @plinetfin

	or di,di
	jge @plinet10
	push ax
	push dx
	mov ax,dx
	sub ax,bp
	imul di
	mov cx,di
	sub cx,bx
	idiv cx
	add bp,ax
	xor di,di
	pop dx
	pop ax
@plinet10:

	cmp bx,ZYSize
	jl @plinet20
	push ax
	mov ax,dx
	sub ax,bp
	mov cx,ZYSize
	dec cx
	sub cx,di
     imul cx
	mov cx,bx
	sub cx,di
	idiv cx
	add ax,bp
	mov dx,ax
     mov bx,ZYSize
	dec bx
	pop ax
@plinet20:
	call ZPLineC
@plinetfin:
end;

procedure ZFillPolyC(NumP:integer;var tabp); assembler;
asm
	cld
	mov cx,NumP
	les bx,tabp
	push bp

@polygone:
	mov NP,cx
	mov word ptr [PTab],bx
	mov word ptr [PTab+2],es
	or cx,cx
	jne @poly05
@polyfin1:
	jmp @polyfin
@poly05:

	push ds
	lds si,Ptab
	mov bx,32000
	mov dx,-32000
	mov di,32000
	mov bp,-32000
@poly1:
	lodsw
	cmp ax,di
     jge @poly4
	mov di,ax
@poly4:
	cmp ax,bp
	jle @poly5
	mov bp,ax
@poly5:
	lodsw
	cmp ax,bx
	jge @poly2
	mov bx,ax
@poly2:
	cmp ax,dx
	jle @poly3
	mov dx,ax
@poly3:
	add si,2
	loop @poly1
	mov ax,bp
	pop ds

	cmp	bx,ZYSize
	jge	@polyfin1
	or	dx,dx
	jl	@polyfin1
     cmp	di,ZXSize
	jge	@polyfin1
	or	ax,ax
	jl	@polyfin1

     or	bx,bx
	jl	@polytest
     cmp	dx,ZYSize
	jge	@polytest
	or	di,di
	jl	@polytest
	cmp	ax,ZXSize
	jge	@polytest
	mov	ZPLineOfs,offset ZPLineC
	jmp  @poly8
@polytest:
	or bx,bx
	jge @poly40
	xor bx,bx
@poly40:
	cmp dx,ZYSize
	jl @poly41
	mov dx,ZYSize
	dec dx
@poly41:
	mov 	ZPLineOfs,offset ZPLineTestC
@poly8:
	mov ax,ds
     mov es,ax
	mov di,offset ZPMinMaxX
	mov cx,dx
	sub cx,bx
	inc cx
	mov Ylen,cx
	add bx,ZYScr
	mov YStart,bx
	mov ax,bx
     shl bx,1
	add bx,ax
	shl bx,1
	add di,bx
	mov Ystart1,di
	mov ax,32767
	mov bx,-32768
@poly20:
	stosw
	xchg ax,bx
	stosw
	xchg ax,bx
	add di,2
	loop @poly20

{	cmp ZPLineOfs,offset ZPLineTestC
	je @polyfin }

     les si,PTab
	mov cx,NP
@poly30:
	push es
	push cx
	mov bp,es:[si]
	mov di,es:[si+2]
	mov al,es:[si+4]
	add si,6
	cmp cx,1
	jne @poly31
	mov si,word ptr PTab
@poly31:
	push si
	mov dx,es:[si]
	mov bx,es:[si+2]
	mov ah,es:[si+4]
     call ZPLineOfs
	pop si
     pop cx
	pop es
	loop @poly30

	cmp ZPLineOfs,offset ZPLineTestC
	jne @poly90


	{ tests de sortie selon x sur chaque ligne, en modifiant les couleurs }

	mov cx,Ylen
	mov si,Ystart1
	mov di,ZXScr
	add di,ZXSize
	dec di
@poly80:
	mov bp,[si]
	mov bx,[si+2]

	cmp bp,di
	jle @poly81
@poly82:
	mov word[si],1
	mov word[si+2],0
	jmp @poly89
@poly81:
	cmp bx,ZXScr
	jl @poly82

	{ si xstart<ZXScr }
	cmp bp,ZXScr
	jge @poly83
     mov ax,ZXScr
	sub ax,bp
	mov dl,[si+5]
	mov dh,0
	sub dl,[si+4]
	sbb dh,0
	imul dx
     sub bp,bx
     idiv bp
     sub [si+4],al
     mov bp,ZXScr
	mov [si],bp
@poly83:
	{ si xfin>ZXScr+ZXSize-1 }
	cmp bx,di
	jle @poly89
	mov ax,di
	sub ax,bp
	mov dl,[si+5]
	mov dh,0
	sub dl,[si+4]
	sbb dh,0
	imul dx
	sub bx,bp
	idiv bx
	add al,[si+4]
	mov [si+5],al
	mov [si+2],di
@poly89:
	add si,6
	loop @poly80

	{ on dessine les lignes }

@poly90:
	mov si,Ystart1
     mov di,Ystart
	mov bx,Ylen
	call FillCProc
@polyfin:
	pop bp
end;







end.


{
	if (y2<0) or (y1>=ZYSize) then Exit;

     if (y1<0) then begin
          x1:=(mul1(-y1,x2-x1) div longint(y2-y1))+x1;
		y1:=0;
	end;
	if (y2>=ZYSize) then begin
          x2:=(mul1(ZYSize-1-y1,x2-x1) div longint(y2-y1))+x1;
          z2:=(mul1(ZYSize-1-y1,z2-z1) div longint(y2-y1))+z1;
		y2:=ZYSize-1;
	end;
}
